;;;; ~/GAME/LEVELS/LEVEL-2-WALL-RADIO.LISP goes with ~/GAME/WALL-RADIO.MAP
(in-package :nic)

;;; Redirect some previous level radio choice towards this map

#|last form in LEVEL-1-STRANDED.LISP:
(setf (get 'ruins :radio-choices)
      '(member
	("Enter the ruins"
	 ((com-change-map REPLACE-WITH-YOUR-LEVEL))))
      (get 'ruins :radio-description)
	   '("The loop terminates as the troupe come across some ruins. " NIL)
      (get 'ruins :radio-lisp-hook)
())
|#


(setf (get 'ruins :radio-choices)
      '(member
	("Enter the ruins"
	 ((com-change-map wall-radio.map))))
      (get 'ruins :radio-description)
	   '("The loop terminates as the troupe come across some ruins. " NIL)
      (get 'ruins :radio-lisp-hook)
())

;;; Impassable:

(push 'wall *impassable*)

;;; Images used here:

(setf (get 'grass :bitmap)
      'techno-mage/imgs/grass.png
      (get 'solid :bitmap)
      'techno-mage/imgs/solid.png
      (get 'example :bitmap)
      'techno-mage/imgs/lambda.png
      (get 'rock :bitmap) 'techno-mage/imgs/rock.png
      (get 'wall :bitmap) 'techno-mage/imgs/tree-2.png
      )

;; radio events:

(setf (get 'example :radio-description)
      '("Lots of
text!"
       asdf grass solid
	(1 2 (3 4) 5))

      (get 'example :radio-lisp-hook)
      (list (lambda () 'nothing)
	    (lambda () 'nothing-else))

      (get 'example :radio-choices)
      '(member
	("choice the first" ((com-set-cur1 rock)))
	("choice the second" ((com-jump 1 1))
	("choice the third" (COM-CHANGE-MAP REPLACE-WITH-YOUR-NEXT-MAP)))))

;; another radio event
(setf (get 'rockradio :radio-description)
      '("Some rocks:"
	rock rock
	#\newline rock "rocks." grass)
      (get 'rockradio :radio-choices)
      '(member
	("good old rock" ((com-game-k)))
	("nothing beats rock" ((COM-CHANGE-MAP your-other-map)))))
